<?php
// TCMB günlük döviz kurları XML dosyasının URL'si
$reqUrl = 'https://www.tcmb.gov.tr/kurlar/today.xml';

// XML dosyasını çekin
$responseXml = file_get_contents($reqUrl);

// Yanıtı kontrol edin ve işlemi devam ettirin
if ($responseXml !== false) {
    try {
        // XML'i parse edin
        $xml = simplexml_load_string($responseXml);
        $json = json_encode($xml);
        $response = json_decode($json, true);

        // 1 GBP'nin TL, USD ve EUR karşılıklarını alalım
        $gbpToTry = null;
        $gbpToUsd = null;
        $gbpToEur = null;

        foreach ($response['Currency'] as $currency) {
            if ($currency['@attributes']['CurrencyCode'] == 'GBP') {
                $gbpToTry = $currency['ForexBuying']; // 1 GBP'nin TL karşılığı
                // USD ve EUR kurlarını dolaylı olarak hesaplayalım
                $usdToTry = null;
                $eurToTry = null;
                
                foreach ($response['Currency'] as $innerCurrency) {
                    if ($innerCurrency['@attributes']['CurrencyCode'] == 'USD') {
                        $usdToTry = $innerCurrency['ForexBuying'];
                    }
                    if ($innerCurrency['@attributes']['CurrencyCode'] == 'EUR') {
                        $eurToTry = $innerCurrency['ForexBuying'];
                    }
                }
                
                if ($usdToTry !== null) {
                    $gbpToUsd = $gbpToTry / $usdToTry;
                }
                
                if ($eurToTry !== null) {
                    $gbpToEur = $gbpToTry / $eurToTry;
                }
                
                break;
            }
        }

        echo "1 GBP to TRY: $gbpToTry\n";
        echo "1 GBP to USD: $gbpToUsd\n";
        echo "1 GBP to EUR: $gbpToEur\n";
    } catch (Exception $e) {
        // XML parse hatası ile ilgilenin
        echo "Error parsing XML: " . $e->getMessage();
    }
}
?>
