<?php

// YouTube kanalınızın RSS feed URL'sini belirtin
$rssFeedUrl = "https://www.youtube.com/feeds/videos.xml?channel_id=UCRYPIZ9i_3HhwoQOtzws1NQ";

// RSS feed'den içerik çekmek için cURL kullan
function fetch_rss_content($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // SSL doğrulama sorunlarını önlemek için
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}

$rssContent = fetch_rss_content($rssFeedUrl);

if ($rssContent === false) {
    die("RSS feed içeriği alınamadı!");
}

$xml = simplexml_load_string($rssContent);
if ($xml === false) {
    die("XML içeriği işlenemedi!");
}

// RSS feed'deki her bir video için döngü oluştur
foreach ($xml->entry as $video) {
    // Video başlığı
    $title = (string)$video->title;

    // Video URL'si
    $videoUrl = (string)$video->link['href'];

    // Video ID'sini çekmek için URL'yi parçala
    parse_str(parse_url($videoUrl, PHP_URL_QUERY), $query);
    $videoId = $query['v'] ?? null;

    if (!$videoId) {
        continue; // Video ID alınamazsa atla
    }

    // Veritabanında video kontrolü
    $video_yoksa_ekle = bk("c", "*youtube_videolar WHERE video = ?", array($videoId));

    if (!$video_yoksa_ekle) {
        // Video veri tabanında yoksa, ekleme işlemini yap
        if (bk("e", "youtube_videolar", array(
            "title" => $title,
            "video" => $videoId
        ))) {
            guzelhaber("Video başarıyla kaydedildi.");
        } else {
            guzelhaber("Video kaydedilemedi!", "2");
        }
    } else {
        guzelhaber("Bu video daha önce kaydedilmiş.", "2");
    }
}
?>
