
<div id="kt_content_container" class="d-flex flex-column-fluid align-items-start container-fluid p-3">
    <!--begin::Post-->
    <div class="content flex-row-fluid" id="kt_content">


        <div class="card mb-5 mb-xl-8">
            <!--begin::Header-->
            <div class="card-header border-0 pt-5">
                <h3 class="card-title align-items-start flex-column">
                   <span class="card-label fw-bold fs-3 mb-1">

                       <i class="ki-duotone ki-profile-user text-success fs-1 ">
                           <span class="path1"></span>
                           <span class="path2"></span>
                           <span class="path3"></span>
                           <span class="path4"></span>
                       </i>
                   Tahsilat Raporu</span>

               </h3>
               <div class="card-toolbar">

                

               </div>
           </div>
           <div class="card-body ">



<?php
try {
    global $depo;

    // Tahsil edilen ve edilemeyen tutarların hesaplanması
    $sorgu = $depo->prepare("
        SELECT SUM(td.tahsilat_tutari) AS tahsil_edilen,
               SUM(s.genel_toplam - COALESCE(td.tahsilat_tutari, 0)) AS tahsil_edilemeyen
        FROM satislar s
        LEFT JOIN tahsilat_detay td ON s.fatura_no = td.fatura_no
    ");
    $sorgu->execute();
    $sonuc = $sorgu->fetch(PDO::FETCH_ASSOC);

    $tahsil_edilen = $sonuc['tahsil_edilen'];
    $tahsil_edilemeyen = $sonuc['tahsil_edilemeyen'];

    // Zaman Bazlı Tahsilat Verileri
    $sorgu = $depo->prepare("
        SELECT DATE(td.islem_tarihi) AS tarih, SUM(td.tahsilat_tutari) AS toplam_tutar
        FROM tahsilat_detay td
        GROUP BY tarih
        ORDER BY tarih
    ");
    $sorgu->execute();
    $zamanBazliTahsilatlar = $sorgu->fetchAll(PDO::FETCH_ASSOC);

    $tarihler = array_column($zamanBazliTahsilatlar, 'tarih');
    $tutarlar = array_column($zamanBazliTahsilatlar, 'toplam_tutar');

    // Fatura ve Tahsilat Detayları
    $sorgu = $depo->prepare("
        SELECT s.fatura_no, s.musteri_id, YEAR(s.fatura_tarihi) AS yil,
               MONTH(s.fatura_tarihi) AS ay, s.fatura_tarihi, s.genel_toplam,
               COALESCE(SUM(td.tahsilat_tutari), 0) AS tahsil_edilen_tutar,
               JSON_ARRAYAGG(JSON_OBJECT(
                    'islem_tarihi', td.islem_tarihi,
                    'tahsilat_tutari', td.tahsilat_tutari,
                    'aciklama', td.aciklama
                )) AS tahsilatlar
        FROM satislar s
        LEFT JOIN tahsilat_detay td ON s.fatura_no = td.fatura_no
        GROUP BY s.fatura_no
        ORDER BY yil, ay, s.fatura_tarihi
    ");
    $sorgu->execute();
    $faturaGruplari = $sorgu->fetchAll(PDO::FETCH_ASSOC);

    // Ay isimleri
    $aylar = [
        1 => "Ocak", 2 => "Şubat", 3 => "Mart", 4 => "Nisan",
        5 => "Mayıs", 6 => "Haziran", 7 => "Temmuz", 8 => "Ağustos",
        9 => "Eylül", 10 => "Ekim", 11 => "Kasım", 12 => "Aralık"
    ];

} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tahsilat Raporları</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .yil-konteyner { display: flex; flex-wrap: wrap; margin-top: 20px; }
        .yil-sutun { flex: 1 1 30%; padding: 10px; box-sizing: border-box; border: 1px solid #ddd; border-radius: 8px; margin: 10px; background-color: #f9f9f9; }
        .yil-sutun h4 { margin-top: 0; color: #333; }
        .fatura-item { margin: 8px 0; padding: 5px; border-radius: 4px; }
        .fatura-item.odenmemis { background-color: #ffcccc; color: #b30000; }
        .btn { padding: 5px 10px; cursor: pointer; background-color: #007bff; color: white; border: none; border-radius: 4px; }
        .modal { display: none; position: fixed; z-index: 1; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.4); }
        .modal-content { background-color: #fefefe; margin: 15% auto; padding: 20px; border: 1px solid #888; width: 80%; max-width: 500px; border-radius: 8px; }
        .close { color: #aaa; float: right; font-size: 28px; font-weight: bold; cursor: pointer; }
        .close:hover, .close:focus { color: black; text-decoration: none; cursor: pointer; }
        .tahsilat-listesi { margin-top: 15px; }
        .tahsilat-item { border-bottom: 1px solid #ddd; padding: 5px 0; }
    </style>
</head>
<body>

<h2>Zaman Bazlı Tahsilat Grafiği</h2>
<canvas id="zamanBazliTahsilatGrafik" width="400" height="100"></canvas>

<script>
// Zaman Bazlı Tahsilat Grafiği
const ctx2 = document.getElementById('zamanBazliTahsilatGrafik').getContext('2d');
new Chart(ctx2, {
    type: 'line',
    data: {
        labels: <?php echo json_encode($tarihler); ?>,
        datasets: [{
            label: 'Tahsilat Tutarı',
            data: <?php echo json_encode($tutarlar); ?>,
            borderColor: '#2196F3',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        plugins: {
            title: { display: true, text: 'Zaman Bazlı Tahsilat' }
        },
        scales: {
            y: { beginAtZero: true, title: { display: true, text: 'Tahsilat Tutarı (₺)' } },
            x: { title: { display: true, text: 'Tarih' } }
        }
    }
});
</script>

<h2>Satış Faturaları</h2>
<div class="yil-konteyner">
    <?php
    foreach ($faturaGruplari as $fatura) {
        $yil = $fatura['yil'];
        $ay = $aylar[$fatura['ay']];
        $faturaNo = $fatura['fatura_no'];
        $faturaTarihi = date("d-m-Y", strtotime($fatura['fatura_tarihi']));
        $genelToplam = number_format($fatura['genel_toplam'], 2);
        $tahsilatDurumu = ($fatura['tahsil_edilen_tutar'] >= $fatura['genel_toplam']) ? "Ödendi" : "Ödenmedi";
        $odenmisSinif = $tahsilatDurumu === "Ödenmedi" ? "odenmemis" : "";
        $musteriID = musteriismi($fatura['musteri_id']);
        $tahsilatlar = json_decode($fatura['tahsilatlar'], true);

        // Kalan bakiyeyi hesapla
        $kalanBakiye = $fatura['genel_toplam'] - $fatura['tahsil_edilen_tutar'];

        if ($currentYear !== $yil) {
            if ($currentYear !== null) {
                echo "</div>";  // Önceki yılın sütununu kapat
            }
            echo "<div class='yil-sutun'><h4>$yil Yılı</h4>";
            $currentYear = $yil;
        }

        echo "<div class='fatura-item $odenmisSinif'>
                <button class='btn btn-warning btn-sm' onclick=\"openModal('$musteriID', '$faturaTarihi', '$genelToplam', '$tahsilatDurumu', " . htmlspecialchars(json_encode($tahsilatlar)) . ", '$kalanBakiye')\"><i class='fas fa-search'></i></button> <strong>Durum:</strong> $tahsilatDurumu <br>
                <strong>$ay</strong> - Fatura Tarihi: $faturaTarihi - 
                <strong>Tutar:</strong> ₺$genelToplam 
              </div>";
    }
    ?>
</div>

<style type="text/css">
/* Modal genel stil */
.modal {
    display: none; /* Başlangıçta gizli */
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.5); /* Siyah arka plan, saydamlık için opaklık */
}

/* Modal içerik stili */
.modal-content {
    position: relative;
    margin: 10% auto;
    padding: 20px;
    width: 80%;
    max-width: 600px;
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    animation: fadeIn 0.3s ease-in-out; /* Açılış animasyonu */
}

/* Kapanma butonu stili */
.close {
    position: absolute;
    top: 10px;
    right: 15px;
    font-size: 20px;
    font-weight: bold;
    color: #333;
    cursor: pointer;
    transition: color 0.3s;
}

.close:hover {
    color: #ff0000;
}

/* Başlıklar için stil */
.modal-content h3, .modal-content h4 {
    margin-top: 0;
    color: #333;
}

/* Tahsilat öğesi stili */
.tahsilat-item {
    padding: 10px;
    margin-bottom: 10px;
    background-color: #f9f9f9;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* Fade-in animasyonu */
@keyframes fadeIn {
    from { opacity: 0; transform: scale(0.9); }
    to { opacity: 1; transform: scale(1); }
}
</style>

<!-- Modal HTML -->
<div id="modal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal()">&times;</span>
        <h3>Fatura Detayları</h3>
        <p><strong>Müşteri ID:</strong> <span id="modal-musteri-id"></span></p>
        <p><strong>Fatura Tarihi:</strong> <span id="modal-fatura-tarihi"></span></p>
        <p><strong>Toplam Tutar:</strong> <span id="modal-toplam"></span> ₺</p>
        <p><strong>Durum:</strong> <span id="modal-durum"></span></p>

        <h4>Tahsilat Detayları</h4>
        <div id="modal-tahsilat-listesi" class="tahsilat-listesi"></div>
        <p><strong>Kalan Bakiye:</strong> <span id="modal-kalan-bakiye"></span></p>
    </div>
</div>

<script>
// Modal açma fonksiyonu
function openModal(musteriID, faturaTarihi, toplam, durum, tahsilatlar, kalanBakiye) {
    document.getElementById('modal').style.display = 'block';
    document.getElementById('modal-musteri-id').innerText = musteriID;
    document.getElementById('modal-fatura-tarihi').innerText = faturaTarihi;
    document.getElementById('modal-toplam').innerText = toplam;
    document.getElementById('modal-durum').innerText = durum;
    
    // Kalan Bakiyeyi Türk Lirası formatında göster
    const formattedBakiye = kalanBakiye ? Number(kalanBakiye).toLocaleString('tr-TR', { style: 'currency', currency: 'TRY' }) : '0 ₺';
    document.getElementById('modal-kalan-bakiye').innerText = formattedBakiye;

    // Tahsilat detaylarını listeleme
    const tahsilatListesi = document.getElementById('modal-tahsilat-listesi');
    tahsilatListesi.innerHTML = ''; // Önceki içeriği temizle

    if (tahsilatlar.length > 0) {
        tahsilatlar.forEach(item => {
            const tahsilatItem = document.createElement('div');
            tahsilatItem.classList.add('tahsilat-item');
            
            // Tarihi Türkçe formatına çevirme
            const tarih = item.islem_tarihi ? new Date(item.islem_tarihi).toLocaleDateString('tr-TR', {
                day: '2-digit',
                month: 'long',
                year: 'numeric'
            }) : 'Yok';
            
            // Tutarı Türk Lirası formatında yazdırma
            const tutar = item.tahsilat_tutari ? Number(item.tahsilat_tutari).toLocaleString('tr-TR', { style: 'currency', currency: 'TRY' }) : '0 ₺';

            tahsilatItem.innerHTML = `<p><strong>Tahsilat Tarihi:</strong> ${tarih} - <strong>Tutar:</strong> ${tutar} <br> <strong>Açıklama:</strong> ${item.aciklama || 'Yok'}</p>`;
            tahsilatListesi.appendChild(tahsilatItem);
        });
    } else {
        tahsilatListesi.innerHTML = '<p>Tahsilat kaydı bulunmamaktadır.</p>';
    }
}

// Modal kapama fonksiyonu
function closeModal() {
    document.getElementById('modal').style.display = 'none';
}
</script>

</body>
</html>





           </div>

       </div>


   </div>
</div>




