
<div id="kt_content_container" class="d-flex flex-column-fluid align-items-start container-fluid p-3">
    <!--begin::Post-->
    <div class="content flex-row-fluid" id="kt_content">


        <div class="card mb-5 mb-xl-8">
            <!--begin::Header-->
            <div class="card-header border-0 pt-5">
                <h3 class="card-title align-items-start flex-column">
                   <span class="card-label fw-bold fs-3 mb-1">

                       <i class="ki-duotone ki-profile-user text-success fs-1 ">
                           <span class="path1"></span>
                           <span class="path2"></span>
                           <span class="path3"></span>
                           <span class="path4"></span>
                       </i>
                   Satış Raporu</span>

               </h3>
               <div class="card-toolbar">

                

               </div>
           </div>
           <div class="card-body ">



<?php
try {
    global $depo;

    // Türkçe ay isimleri dizisi
    $turkceAylar = [
        1 => "Ocak", 
        2 => "Şubat", 
        3 => "Mart", 
        4 => "Nisan", 
        5 => "Mayıs", 
        6 => "Haziran", 
        7 => "Temmuz", 
        8 => "Ağustos", 
        9 => "Eylül", 
        10 => "Ekim", 
        11 => "Kasım", 
        12 => "Aralık"
    ];

    // Tarih formatlaması için Türkçe dil ayarı
    setlocale(LC_TIME, 'tr_TR.UTF-8', 'turkish');

    // Sorguyu çalıştır ve veriyi al
    $sorgu = $depo->prepare("
        SELECT 
            YEAR(fatura_tarihi) AS yil, 
            MONTH(fatura_tarihi) AS ay, 
            fatura_tarihi,
            fatura_no,
            musteri_id,
            genel_toplam AS toplam_tutar 
        FROM satislar 
        ORDER BY yil, ay, fatura_tarihi;
    ");

    $sorgu->execute();
    $bk_cikti = $sorgu->fetchAll(PDO::FETCH_ASSOC);

    // Grafik ve listeleme verileri hazırlama
    $veri = [];
    foreach ($bk_cikti as $satis) {
        $yil = $satis['yil'];
        $ay = $turkceAylar[$satis['ay']];
        $toplam = $satis['toplam_tutar'];
        $faturaNo = $satis['fatura_no'];
        $musteriID = $satis['musteri_id'];
        $faturaTarihi = strftime("%d %B %Y", strtotime($satis['fatura_tarihi'])); 

        $veri[$yil][$ay]['toplam'] = ($veri[$yil][$ay]['toplam'] ?? 0) + $toplam;
        $veri[$yil][$ay]['satislar'][] = [
            'fatura_tarihi' => $faturaTarihi,
            'fatura_no' => $faturaNo,
            'musteri_id' => $musteriID,
            'tutar' => $toplam
        ];
    }

} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}

$yillar = array_keys($veri);
$aylar = array_values($turkceAylar);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Satış Grafiği</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .yil-sutunlari { display: flex; flex-wrap: wrap; margin-top: 30px; }
        .yil-sutun { flex: 1 1 30%; box-sizing: border-box; padding: 10px; margin: 5px; background-color: #f9f9f9; border: 1px solid #ddd; border-radius: 8px; }
        .yil-sutun h3 { margin-top: 0; color: #333; }
        .yil-sutun .ay { margin-bottom: 10px; }
        .yil-sutun .ay h4 { margin: 5px 0; color: #555; }
        .yil-sutun .satis { margin-left: 15px; font-size: 14px; color: #777; }
        /* Modal stil */
        .modal { display: none; position: fixed; z-index: 1; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.4); }
        .modal-content { background-color: #fefefe; margin: 15% auto; padding: 20px; border: 1px solid #888; width: 80%; max-width: 500px; border-radius: 8px; }
        .close { color: #aaa; float: right; font-size: 28px; font-weight: bold; cursor: pointer; }
        .close:hover, .close:focus { color: black; text-decoration: none; cursor: pointer; }
    </style>
</head>
<body>

<canvas id="satisGrafik" width="400" height="100"></canvas>

<script>
// Chart.js ile grafik oluşturma (PHP verilerini kullanarak)
const aylar = <?php echo json_encode($aylar); ?>;
const yillar = <?php echo json_encode($yillar); ?>;
const toplamlar = <?php echo json_encode(array_map(fn($y) => array_column($veri[$y], 'toplam'), $yillar)); ?>;

const ctx = document.getElementById('satisGrafik').getContext('2d');
const satisGrafik = new Chart(ctx, {
    type: 'line',
    data: {
        labels: aylar,
        datasets: yillar.map((yil, index) => ({
            label: yil + " Yılı",
            data: toplamlar[index],
            fill: false,
            borderColor: `hsl(${index * 60}, 70%, 50%)`,
            tension: 0.1
        }))
    },
    options: {
        responsive: true,
        plugins: {
            legend: { position: 'top' },
            title: { display: true, text: 'Aylık Satış Toplamları (Yıllara Göre)' }
        },
        scales: {
            y: { beginAtZero: true, title: { display: true, text: 'Toplam Satış (₺)' } },
            x: { title: { display: true, text: 'Aylar' } }
        }
    }
});

// Modal işlemleri
function openModal(faturaNo, tarih, tutar, musteriID) {
    document.getElementById('modal').style.display = 'block';
    document.getElementById('modal-fatura-no').innerText = faturaNo;
    document.getElementById('modal-musteri').innerText = musteriID;
    document.getElementById('modal-tarih').innerText = tarih;
    document.getElementById('modal-tutar').innerText = tutar + " ₺";
    
}

function closeModal() {
    document.getElementById('modal').style.display = 'none';
}
</script>

<style type="text/css">
/* Modal genel stil */
.modal {
    display: none; /* Başlangıçta gizli */
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.5); /* Siyah arka plan, saydamlık için opaklık */
}

/* Modal içerik stili */
.modal-content {
    position: relative;
    margin: 10% auto;
    padding: 20px;
    width: 80%;
    max-width: 600px;
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    animation: fadeIn 0.3s ease-in-out; /* Açılış animasyonu */
}

/* Kapanma butonu stili */
.close {
    position: absolute;
    top: 10px;
    right: 15px;
    font-size: 20px;
    font-weight: bold;
    color: #333;
    cursor: pointer;
    transition: color 0.3s;
}

.close:hover {
    color: #ff0000;
}

/* Başlıklar için stil */
.modal-content h3, .modal-content h4 {
    margin-top: 0;
    color: #333;
}

/* Tahsilat öğesi stili */
.tahsilat-item {
    padding: 10px;
    margin-bottom: 10px;
    background-color: #f9f9f9;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* Fade-in animasyonu */
@keyframes fadeIn {
    from { opacity: 0; transform: scale(0.9); }
    to { opacity: 1; transform: scale(1); }
}
</style>

<!-- Modal HTML -->
<div id="modal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal()">&times;</span>
        <h3>Fatura Detayları</h3>
        <p><strong>Fatura No:</strong> <span id="modal-fatura-no"></span></p>
        <p><strong>Müşteri:</strong> <span id="modal-musteri"></span></p>
        <p><strong>Fatura Tarihi:</strong> <span id="modal-tarih"></span></p>
        <p><strong>Tutar:</strong> <span id="modal-tutar"></span></p>
        
    </div>
</div>

<!-- Yılları, ayları ve satışlarını listeleme -->
<div class="yil-sutunlari">
    <?php foreach ($veri as $yil => $aylar) { ?>
        <div class="yil-sutun">
            <h3><?php echo $yil; ?> Yılı</h3>
            <?php foreach ($aylar as $ay => $ayVeri) { 
                $siraNumarasi = 1; 
                $toplamSatisSayisi = count($ayVeri['satislar']); 
            ?>
                <div class="ay">
                    <h4><?php echo $ay; ?> - Toplam: <?php echo number_format($ayVeri['toplam'], 2); ?> ₺</h4>
                    <p><strong>Toplam Satış Sayısı:</strong> <?php echo $toplamSatisSayisi; ?></p>
                    <?php foreach ($ayVeri['satislar'] as $satis) { ?>
                        <div class="satis mb-3">
                            <button onclick="openModal('<?php echo $satis['fatura_no']; ?>', '<?php echo $satis['fatura_tarihi']; ?>', '<?php echo number_format($satis['tutar'], 2); ?>', '<?php echo musteriismi($satis['musteri_id']); ?>')" class="btn btn-success btn-icon btn-sm">
                                <i class="ki-duotone ki-magnifier fs-2">
                                    <span class="path1"></span>
                                    <span class="path2"></span>
                                    <span class="path3"></span>
                                </i>
                            </button>
                            <strong><?php echo $siraNumarasi++; ?>. Fatura Tarihi: </strong><?php echo $satis['fatura_tarihi']; ?> - <strong>Tutar: </strong><?php echo number_format($satis['tutar'], 2); ?> ₺
                            
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
    <?php } ?>
</div>

</body>
</html>

<style>
    /* Diğer CSS kodlarınız */
    
    /* Modal stil */
    .modal { display: none; position: fixed; z-index: 1; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.4); }
    .modal-content { background-color: #fefefe; margin: 15% auto; padding: 20px; border: 1px solid #888; width: 1000px; max-width: 90%; border-radius: 8px; }
    .close { color: #aaa; float: right; font-size: 28px; font-weight: bold; cursor: pointer; }
    .close:hover, .close:focus { color: black; text-decoration: none; cursor: pointer; }
</style>




           </div>

       </div>


   </div>
</div>




