<?php
try {
    global $depo;

    // Türkçe ay isimleri dizisi
    $turkceAylar = [
        1 => "Ocak", 
        2 => "Şubat", 
        3 => "Mart", 
        4 => "Nisan", 
        5 => "Mayıs", 
        6 => "Haziran", 
        7 => "Temmuz", 
        8 => "Ağustos", 
        9 => "Eylül", 
        10 => "Ekim", 
        11 => "Kasım", 
        12 => "Aralık"
    ];

    // Tarih formatlaması için Türkçe dil ayarı
    setlocale(LC_TIME, 'tr_TR.UTF-8', 'turkish');

    // Sorguyu çalıştır ve veriyi al
    $sorgu = $depo->prepare("
        SELECT 
            masraf_yil AS yil, 
            masraf_ay AS ay, 
            islem_tarihi, 
            masraf_aciklama, 
            masraf_ucreti, 
            masraf_hesap_id 
        FROM masraf_detaylari 
        WHERE masraf_ucreti > 0.00
        ORDER BY yil, ay, islem_tarihi;
    ");

    $sorgu->execute();
    $bk_cikti = $sorgu->fetchAll(PDO::FETCH_ASSOC);

    // Grafik ve listeleme verileri hazırlama
    $veri = [];
    foreach ($bk_cikti as $masraf) {
        $yil = $masraf['yil'];
        $ay = $turkceAylar[$masraf['ay']];
        $toplam = $masraf['masraf_ucreti'];
        $masrafTuru = $masraf['masraf_aciklama'];
        $masrafTarihi = strftime("%d %B %Y", strtotime($masraf['islem_tarihi']));
        $masrafHesapID = $masraf['masraf_hesap_id'];

        $veri[$yil][$ay]['toplam'] = ($veri[$yil][$ay]['toplam'] ?? 0) + $toplam;
        $veri[$yil][$ay]['masraflar'][] = [
            'islem_tarihi' => $masrafTarihi,
            'masraf_aciklama' => $masrafTuru,
            'masraf_hesap_id' => $masrafHesapID,
            'tutar' => $toplam
        ];
    }

} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}

$yillar = array_keys($veri);
$aylar = array_values($turkceAylar);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Masraf Grafiği</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>

<canvas id="masrafGrafik" width="400" height="100"></canvas>

<script>
// Chart.js ile grafik oluşturma (PHP verilerini kullanarak)
const aylar = <?php echo json_encode($aylar); ?>;
const yillar = <?php echo json_encode($yillar); ?>;
const toplamlar = <?php echo json_encode(array_map(fn($y) => array_column($veri[$y], 'toplam'), $yillar)); ?>;

const ctx = document.getElementById('masrafGrafik').getContext('2d');
const masrafGrafik = new Chart(ctx, {
    type: 'line',
    data: {
        labels: aylar,
        datasets: yillar.map((yil, index) => ({
            label: yil + " Yılı",
            data: toplamlar[index],
            fill: false,
            borderColor: `hsl(${index * 60}, 70%, 50%)`,
            tension: 0.1
        }))
    },
    options: {
        responsive: true,
        plugins: {
            legend: { position: 'top' },
            title: { display: true, text: 'Aylık Masraf Toplamları (Yıllara Göre)' }
        },
        scales: {
            y: { beginAtZero: true, title: { display: true, text: 'Toplam Masraf (₺)' } },
            x: { title: { display: true, text: 'Aylar' } }
        }
    }
});
</script>

<!-- Yılları, ayları ve masrafları listeleme -->
<section>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12 ">
                <div class="yil-sutunlari text-center">
                    <?php foreach ($veri as $yil => $aylar) { ?>
                        <div class="yil-sutun">
                            <h3><?php echo $yil; ?> Yılı</h3>
                            <hr>
                            <?php foreach ($aylar as $ay => $ayVeri) { 
                                $siraNumarasi = 1; 
                                $toplamMasrafSayisi = count($ayVeri['masraflar']); 
                            ?>
                                <div class="ay">
                                    <hr>
                                    <h4><?php echo $yil; ?> - <?php echo $ay; ?> - Toplam: <?php echo number_format($ayVeri['toplam'], 2); ?> ₺</h4>
                                    <hr>
                                    <p><strong>Toplam Masraf Sayısı:</strong> <?php echo $toplamMasrafSayisi; ?></p>
                                    <hr>
                                    <div class="row">
                                        <?php foreach ($ayVeri['masraflar'] as $masraf) { ?>
                                            <div class="masraf mb-3 col-md-3" style="padding: 2px;">
                                                <div style="border: 1px solid #333; border-radius: 10px; padding: 10px; text-align: left; background: #fff2b9;">
                                                    <strong><?php echo $siraNumarasi++; ?>. Tarih: </strong><?php echo $masraf['islem_tarihi']; ?><br>
                                                    <strong>Masraf Adı: </strong><?php echo masraffirmaismi($masraf['masraf_hesap_id']); ?><br>
                <?php $masraf_kategori_adi = bk("c","SELECT * FROM masraf_hesaplari where id = ?",array($masraf['masraf_hesap_id'])); ?>
                    <strong>Tutar: </strong><?php echo number_format($masraf['tutar'], 2); ?> ₺ (<?php echo masrafkategoriismi($masraf_kategori_adi['masraf_kategori_id']); ?>)<br>
                                                    <strong>Açıklama: </strong><?php echo $masraf['masraf_aciklama']; ?>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>


</body>
</html>
