<div id="kt_content_container" class="d-flex flex-column-fluid align-items-start container-fluid p-3">
    <!--begin::Post-->
    <div class="content flex-row-fluid" id="kt_content">


        <div class="card mb-5 mb-xl-8">
            <!--begin::Header-->
            <div class="card-header border-0 pt-5">
                <h3 class="card-title align-items-start flex-column">
                   <span class="card-label fw-bold fs-3 mb-1">

                       <i class="ki-duotone ki-profile-user text-success fs-1 ">
                           <span class="path1"></span>
                           <span class="path2"></span>
                           <span class="path3"></span>
                           <span class="path4"></span>
                       </i>
                   Banka Raporu</span>

               </h3>
               <div class="card-toolbar">

                

               </div>
           </div>
           <div class="card-body ">

<?php
try {
    global $depo;

    // Türkçe ay isimleri dizisi
    $turkceAylar = [
        1 => "Ocak", 
        2 => "Şubat", 
        3 => "Mart", 
        4 => "Nisan", 
        5 => "Mayıs", 
        6 => "Haziran", 
        7 => "Temmuz", 
        8 => "Ağustos", 
        9 => "Eylül", 
        10 => "Ekim", 
        11 => "Kasım", 
        12 => "Aralık"
    ];

    // Tarih formatlaması için Türkçe dil ayarı
    setlocale(LC_TIME, 'tr_TR.UTF-8', 'turkish');

    // Sorguyu çalıştır ve veriyi al
    $sorgu = $depo->prepare("
        SELECT 
            YEAR(islem_tarihi) AS yil, 
            MONTH(islem_tarihi) AS ay, 
            islem_tarihi,
            fatura_no,
            aciklama,
            giris,
            cikis
        FROM banka_detaylar 
        WHERE banka_id = :banka_id
        ORDER BY yil, ay, islem_tarihi;
    ");


    // Örnek bir banka_id değeri girin veya dinamik olarak alın
    $banka_id = isset($_GET['id']) ? intval($_GET['id']) : 0; // Örneğin, 1 ID'sini alıyoruz
    $sorgu->bindParam(':banka_id', $banka_id, PDO::PARAM_INT);
    $sorgu->execute();
    $bk_cikti = $sorgu->fetchAll(PDO::FETCH_ASSOC);

    // Grafik ve listeleme verileri hazırlama
    $veri = [];
    foreach ($bk_cikti as $islem) {
        $yil = $islem['yil'];
        $ay = $turkceAylar[$islem['ay']];
        $giris = $islem['giris'];
        $cikis = $islem['cikis'];
        $faturaNo = $islem['fatura_no'];
        $aciklama = $islem['aciklama'];
        $islemTarihi = strftime("%d %B %Y", strtotime($islem['islem_tarihi'])); 

        // Aylık giriş ve çıkışları toplama
        $veri[$yil][$ay]['toplam_giris'] = ($veri[$yil][$ay]['toplam_giris'] ?? 0) + $giris;
        $veri[$yil][$ay]['toplam_cikis'] = ($veri[$yil][$ay]['toplam_cikis'] ?? 0) + $cikis;
        $veri[$yil][$ay]['islemler'][] = [
            'islem_tarihi' => $islemTarihi,
            'fatura_no' => $faturaNo,
            'aciklama' => $aciklama,
            'giris' => $giris,
            'cikis' => $cikis
        ];
    }

} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}

$yillar = array_keys($veri);
$aylar = array_values($turkceAylar);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Banka Raporu</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .yil-sutunlari { display: flex; flex-wrap: wrap; margin-top: 30px; }
        .yil-sutun { flex: 1 1 30%; box-sizing: border-box; padding: 10px; margin: 5px; background-color: #f9f9f9; border: 1px solid #ddd; border-radius: 8px; }
        .yil-sutun h3 { margin-top: 0; color: #333; }
        .yil-sutun .ay { margin-bottom: 10px; }
        .yil-sutun .ay h4 { margin: 5px 0; color: #555; }
        .yil-sutun .islem { margin-left: 15px; font-size: 14px; color: #777; }
        /* Modal stil */
        .modal { display: none; position: fixed; z-index: 1; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.4); }
        .modal-content { background-color: #fefefe; margin: 15% auto; padding: 20px; border: 1px solid #888; width: 80%; max-width: 500px; border-radius: 8px; }
        .close { color: #aaa; float: right; font-size: 28px; font-weight: bold; cursor: pointer; }
        .close:hover, .close:focus { color: black; text-decoration: none; cursor: pointer; }
    </style>
</head>
<body>

<canvas id="bankaGrafik" width="400" height="100"></canvas>

<script>
// Chart.js ile grafik oluşturma (PHP verilerini kullanarak)
const aylar = <?php echo json_encode($aylar); ?>;
const yillar = <?php echo json_encode($yillar); ?>;
const girisler = <?php echo json_encode(array_map(fn($y) => array_column($veri[$y], 'toplam_giris'), $yillar)); ?>;
const cikislar = <?php echo json_encode(array_map(fn($y) => array_column($veri[$y], 'toplam_cikis'), $yillar)); ?>;

const ctx = document.getElementById('bankaGrafik').getContext('2d');
const bankaGrafik = new Chart(ctx, {
    type: 'line',
    data: {
        labels: aylar,
        datasets: yillar.flatMap((yil, index) => [
            {
                label: yil + " Yılı Giriş",
                data: girisler[index],
                fill: false,
                borderColor: `hsl(${index * 60}, 70%, 50%)`,
                tension: 0.1
            },
            {
                label: yil + " Yılı Çıkış",
                data: cikislar[index],
                fill: false,
                borderColor: `hsl(${index * 60 + 180}, 70%, 50%)`,
                tension: 0.1
            }
        ])
    },
    options: {
        responsive: true,
        plugins: {
            legend: { position: 'top' },
            title: { display: true, text: 'Aylık Giriş ve Çıkış Toplamları (Yıllara Göre)' }
        },
        scales: {
            y: { beginAtZero: true, title: { display: true, text: 'Tutar (₺)' } },
            x: { title: { display: true, text: 'Aylar' } }
        }
    }
});

// Modal işlemleri
function openModal(faturaNo, tarih, giris, cikis, aciklama) {
    document.getElementById('modal').style.display = 'block';
    document.getElementById('modal-fatura-no').innerText = faturaNo;
    document.getElementById('modal-aciklama').innerText = aciklama;
    document.getElementById('modal-tarih').innerText = tarih;
    document.getElementById('modal-giris').innerText = giris + " ₺";
    document.getElementById('modal-cikis').innerText = cikis + " ₺";
}

function closeModal() {
    document.getElementById('modal').style.display = 'none';
}
</script>

<style type="text/css">
/* Modal genel stil */
.modal {
    display: none; /* Başlangıçta gizli */
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.5); /* Siyah arka plan, saydamlık için opaklık */
}

/* Modal içerik stili */
.modal-content {
    position: relative;
    margin: 10% auto;
    padding: 20px;
    width: 80%;
    max-width: 600px;
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    animation: fadeIn 0.3s ease-in-out; /* Açılış animasyonu */
}

/* Kapanma butonu stili */
.close {
    position: absolute;
    top: 10px;
    right: 15px;
    font-size: 20px;
    font-weight: bold;
    color: #333;
    cursor: pointer;
    transition: color 0.3s;
}

.close:hover {
    color: #ff0000;
}

/* Başlıklar için stil */
.modal-content h3, .modal-content h4 {
    margin-top: 0;
    color: #333;
}

/* Tahsilat öğesi stili */
.tahsilat-item {
    padding: 10px;
    margin-bottom: 10px;
    background-color: #f9f9f9;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* Fade-in animasyonu */
@keyframes fadeIn {
    from { opacity: 0; transform: scale(0.9); }
    to { opacity: 1; transform: scale(1); }
}
</style>

<!-- Modal HTML -->
<div id="modal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal()">&times;</span>
        <h3>İşlem Detayları</h3>
        <p><strong>Fatura No:</strong> <span id="modal-fatura-no"></span></p>
        <p><strong>Açıklama:</strong> <span id="modal-aciklama"></span></p>
        <p><strong>İşlem Tarihi:</strong> <span id="modal-tarih"></span></p>
        <p><strong>Giriş Tutarı:</strong> <span id="modal-giris"></span></p>
        <p><strong>Çıkış Tutarı:</strong> <span id="modal-cikis"></span></p>
    </div>
</div>

<!-- Yılları, ayları ve işlemleri listeleme -->
<div class="yil-sutunlari">
    <?php foreach ($veri as $yil => $aylar) { ?>
        <div class="yil-sutun">
            <h3><?php echo $yil; ?> Yılı</h3>
            <?php foreach ($aylar as $ay => $ayVeri) { 
                $siraNumarasi = 1; 
                $toplamIslemSayisi = count($ayVeri['islemler']); 
            ?>
                <div class="ay">
                    <h4><?php echo $ay; ?> <br>
                        Toplam Giriş: <?php echo number_format($ayVeri['toplam_giris'], 2); ?> ₺, Toplam Çıkış: <?php echo number_format($ayVeri['toplam_cikis'], 2); ?> ₺</h4>
                    <p><strong>Toplam İşlem Sayısı:</strong> <?php echo $toplamIslemSayisi; ?></p>
                    <?php foreach ($ayVeri['islemler'] as $islem) { ?>
                        <div class="islem mb-3">
                            <button onclick="openModal('<?php echo $islem['fatura_no']; ?>', '<?php echo $islem['islem_tarihi']; ?>', '<?php echo number_format($islem['giris'], 2); ?>', '<?php echo number_format($islem['cikis'], 2); ?>', '<?php echo $islem['aciklama']; ?>')" class="btn btn-success btn-icon btn-sm">
                                <i class="fas fa-search"></i>
                            </button>
                            <strong><?php echo $siraNumarasi++; ?>. İşlem Tarihi: </strong><?php echo $islem['islem_tarihi']; ?> <br> <strong>Giriş: </strong><?php echo number_format($islem['giris'], 2) ?: '0,00'; ?> ₺ - <strong>Çıkış: </strong><?php echo number_format($islem['cikis'], 2) ?: '0,00'; ?> ₺
                        </div>
                    <?php } ?>
                    <hr>
                </div>
            <?php } ?>
        </div>
    <?php } ?>
</div>

</body>
</html>

<style>
    /* Diğer CSS kodlarınız */
    
    /* Modal stil */
    .modal { display: none; position: fixed; z-index: 1; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.4); }
    .modal-content { background-color: #fefefe; margin: 15% auto; padding: 20px; border: 1px solid #888; width: 1000px; max-width: 90%; border-radius: 8px; }
    .close { color: #aaa; float: right; font-size: 28px; font-weight: bold; cursor: pointer; }
    .close:hover, .close:focus { color: black; text-decoration: none; cursor: pointer; }
</style>

</div>

       </div>


   </div>
</div>

