<?php

require '../panel/system/start/config.php'; 
require '../panel/system/start/function.php';

// Ay ve yıl bilgilerini al
date_default_timezone_set('Europe/Istanbul');
$current_day = (int)date('j'); // Gün (1-31)
$current_month = (int)date('n'); // Ay (1-12)
$current_year = (int)date('Y'); // Yıl (YYYY)
$current_date = date('Y-m-d'); // İşlem tarihi (YYYY-MM-DD)

$current_month_onceki = $current_month - 1;

// Ay isimlerini tanımlayın
$aylar = [
    1 => "Ocak",
    2 => "Şubat",
    3 => "Mart",
    4 => "Nisan",
    5 => "Mayıs",
    6 => "Haziran",
    7 => "Temmuz",
    8 => "Ağustos",
    9 => "Eylül",
    10 => "Ekim",
    11 => "Kasım",
    12 => "Aralık"
];

// Geçerli ay ismini alın
$turkce_ay = $aylar[$current_month_onceki];

// İşlem yalnızca ayın 1. günü yapılmalı
if ($current_day === 1) {
    // Gerekli bilgiler
    $masraf_hesap_id = 47;
    $masraf_aciklama = "Maaş Hakediş " . $turkce_ay; // Türkçe ay adı eklendi
    $masraf_ucreti = 60000;

    // Veritabanına ekleme işlemi
    $insert_result = bk("e", "masraf_detaylari", array(
        "masraf_hesap_id" => $masraf_hesap_id,
        "masraf_ay" => $current_month,
        "masraf_yil" => $current_year,
        "masraf_aciklama" => $masraf_aciklama,
        "masraf_ucreti" => $masraf_ucreti,
        "islem_tarihi" => $current_date
    ));

    // İşlem sonucunu kontrol et
    if ($insert_result) {
        echo "Maaş ücreti başarıyla eklendi: $current_date\n";
    } else {
        echo "Maaş ücreti eklenirken bir hata oluştu.\n";
    }
} else {
    echo "Bugün belirlenen gün değil, işlem yapılmadı.\n";
}

// Veritabanı bağlantısını kapat
mysqli_close($conn);
?>
