<?php

require '../panel/system/start/config.php'; 
require '../panel/system/start/function.php';

// TCMB günlük döviz kurları XML dosyasının URL'si
$reqUrl = 'https://www.tcmb.gov.tr/kurlar/today.xml';

// XML dosyasını çekin
$responseXml = file_get_contents($reqUrl);

// Yanıtı kontrol edin ve işlemi devam ettirin
if ($responseXml !== false) {
    try {
        // XML'i parse edin
        $xml = simplexml_load_string($responseXml);
        $json = json_encode($xml);
        $response = json_decode($json, true);

        // TL'nin USD, EUR, GBP, RUB, CNY karşılıklarını almak için bir array oluşturun
        $exchangeRates = [
            'USD' => null,
            'EUR' => null,
            'GBP' => null,
            'RUB' => null,
            'CNY' => null
        ];

        // Döviz kurlarını al
        foreach ($response['Currency'] as $currency) {
            $currencyCode = $currency['@attributes']['CurrencyCode'];
            if (array_key_exists($currencyCode, $exchangeRates)) {
                $exchangeRates[$currencyCode] = $currency['ForexBuying']; // Alış kurunu alın
            }
        }

        // Sonuçları yazdır
        echo "1 TRY to USD: {$exchangeRates['USD']}\n";
        echo "1 TRY to EUR: {$exchangeRates['EUR']}\n";
        echo "1 TRY to GBP: {$exchangeRates['GBP']}\n";
        echo "1 TRY to RUB: {$exchangeRates['RUB']}\n";
        echo "1 TRY to CNY: {$exchangeRates['CNY']}\n";

        // Veritabanına kaydet (bk fonksiyonunuzu kullanarak)
        bk("e", "doviz", [
            "USD" => $exchangeRates['USD'],
            "EUR" => $exchangeRates['EUR'],
            "GBP" => $exchangeRates['GBP'],
            "RUB" => $exchangeRates['RUB'],
            "CNY" => $exchangeRates['CNY']
        ]);

    } catch (Exception $e) {
        // XML parse hatası ile ilgilenin
        echo "Error parsing XML: " . $e->getMessage();
    }
} else {
    echo "XML dosyasına erişilemedi.";
}
?>
