<?php

require '../panel/system/start/config.php'; 
require '../panel/system/start/function.php';

// Geçerli ayı belirleyin
date_default_timezone_set('Europe/Istanbul');
$guncel_ay = strtolower(date('F')); // Ay ismini küçük harfle alır: "january", "february", vb.

// Ay isimlerini Türkçeye çevirin
$aylar = array(
    "january" => "ocak",
    "february" => "subat",
    "march" => "mart",
    "april" => "nisan",
    "may" => "mayis",
    "june" => "haziran",
    "july" => "temmuz",
    "august" => "agustos",
    "september" => "eylul",
    "october" => "ekim",
    "november" => "kasim",
    "december" => "aralik"
);

// Geçerli ayı Türkçe olarak alın
$turkce_ay = $aylar[$guncel_ay];

echo $turkce_ay;

foreach (bk("cc", "*abonelikler where abonelik_turu = 'Yıllık'") as $abonelik) {
    // Geçerli tarih bilgilerini al
    date_default_timezone_set('Europe/Istanbul');
    $current_month_numeric = (int)date('n'); // Geçerli ay (1-12)
    $current_year = (int)date('Y'); // Geçerli yıl

    // Başlangıç tarihini kontrol et
    $start_month_numeric = array_search(strtolower($abonelik['abonelik_basla_ay']), [
        'ocak', 'subat', 'mart', 'nisan', 'mayis', 'haziran',
        'temmuz', 'agustos', 'eylul', 'ekim', 'kasim', 'aralik'
    ]) + 1; // Ayı sayıya çevir (1-12)

    $start_year = (int)$abonelik['abonelik_basla_yil'];

    // Abonelik henüz başlamamışsa bu satırı atla
    if ($start_year > $current_year || ($start_year == $current_year && $start_month_numeric > $current_month_numeric)) {
        continue; // Bu satırda işlem yapmadan döngünün sonraki iterasyonuna geç
    }

    // Dinamik ay sütununu kontrol etmek için
    if (isset($abonelik[$turkce_ay]) && $abonelik[$turkce_ay] == 1 && $abonelik['kalan_sure'] > 0) {
        // Kalan süreyi bir azalt
        $abonelik['kalan_sure'] -= 1;
        $abonelik['toplam_sure'] += 1;

        // Veritabanında güncelle
        if (bk("g", "abonelikler/abonelik_turu=:abonelik_turu AND $turkce_ay=1 AND id=:id", array(
            "@abonelik_turu" => 'Yıllık',
            "$turkce_ay" => 0, // İlgili ay sütununun değerini 0 yap
            "id" => $abonelik['id'], // Her satırın benzersiz ID'si
            "kalan_sure" => $abonelik['kalan_sure'], // Güncel kalan süreyi gönder
            "toplam_sure" => $abonelik['toplam_sure'] // Güncel toplam süreyi gönder
        ))) {
            guzelhaber();
        } else {
            guzelhaber("Başarısız", "2");
        }
    }
}


// Veritabanı bağlantısını kapatın
mysqli_close($conn);
?>
